<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:m1="http://www.sec.gov/edgar/mafiler"
	xmlns:ns1="http://www.sec.gov/edgar/common"
	xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/common_ma"
	xmlns:n2="http://www.sec.gov/edgar/ma_common_drp"
	xmlns:ns3="http://www.sec.gov/edgar/ma_drp">
	
	
	
	<!-- Item 9 templates -->
	
<xsl:template name="Item9" >

<p><em>In this Item, provide information about the criminal, regulatory, and judicial history, if any, of the applicant and each associated person of the applicant.</em>  </p>
<p><em>This information is used to determine whether to approve an application for registration, to decide whether to revoke registration, or to place limitations on the applicant's activities as a municipal advisor, and to identify potential problem areas on which to focus during on-site examinations. One event may result in the requirement to answer &quot;Yes&quot; to more than one question below.</em>  </p>
<p><em>Refer to the Glossary of Terms for explanations of italicized terms, such as associated person.</em></p>
<h3>Criminal Action Disclosure</h3>
<p><em>If the answer is &quot;Yes&quot; to any question below in Part A or B below, complete a </em> <em><u><b>Criminal Action DRP</b></u></em>. </p>
<p><em> Disclosure of any event listed in this Criminal Action Disclosure Section <span class="double_underline"> is not required if</span> the date of the event <span class="double_underline"> was more than ten years ago</span>. For purposes of calculating this ten-year period, the date of an event is the date that the final <em>order</em>, judgment, or decree was entered, or the date that any rights of appeal from preliminary <em>order</em>s, judgments, or decrees lapsed.</em></p>
  
<p>Check all that apply.</p>
<h3>A. In the past ten years, has the applicant or any <em>associated person</em>: </h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) been convicted of any <em>felony</em>, or pled guilty or nolo contendere (&quot;no contest&quot;) to any <em>charge</em>  of a <em>felony</em>, in a domestic, foreign, or military court?</div>
    <div class="tdStyle1 tditem10col2">     
		<xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isConvictedOfFelony = 'Y' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isConvictedOfFelony = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isConvictedOfFelony = 'N' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isConvictedOfFelony = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
				</xsl:when>
				<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
				</xsl:otherwise>
		</xsl:choose>      
   </div>
  </div>
  <div style="clear:both"></div>
</div>
<div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) been <em>charged</em>  with any <em>felony</em>?</div>
    <div class="tdStyle1 tditem10col2">
    	<xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isChargedWithFelony = 'Y' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isChargedWithFelony = 'y'">
						<img src="Images/radio-checked.jpg" alt="radio button checked" />Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
						  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isChargedWithFelony = 'N' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isChargedWithFelony = 'n'">
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
						  
				</xsl:when>
				<xsl:otherwise>
						<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
				</xsl:otherwise>
		</xsl:choose>          
 </div>
  </div>
  <div style="clear:both"></div>
</div>
<p><em>The response to Item 9-A(2) may be limited to charges that are currently pending. </em> </p>
<h3>B. In the past ten years, has the applicant or any <em>associated person</em>: </h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) been convicted of any <em>misdemeanor</em>, or pled guilty or nolo contendere (&quot;no contest&quot;), in a domestic, foreign, or military court to any <em>charge</em>  of a <em>misdemeanor</em>  in a case <em>involving</em>: <em>municipal advisor-related</em>  business, investments or an <em>investment-related</em>  business, or any fraud, false statements, or omissions, wrongful taking of property, bribery, perjury, forgery, counterfeiting, extortion, or a conspiracy to commit any of these offenses? </div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when
				test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgConvictedOfFelony = 'Y' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgConvictedOfFelony = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
					  
			</xsl:when>
			<xsl:when
				test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgConvictedOfFelony = 'N' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgConvictedOfFelony = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
					  
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:otherwise>
		</xsl:choose>              
    </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) been <em>charged</em>  with a <em>misdemeanor</em>  of the kind listed in Item 9-B(1)?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when
				test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgChargedWithFelony = 'Y' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgChargedWithFelony = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					  
			</xsl:when>
			<xsl:when
				test="m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgChargedWithFelony = 'N' or m1:disclosureAnswers/m1:criminalDisclosure/ns2:isOrgChargedWithFelony = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
					  
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
		</xsl:choose>     
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<p><em>The response to Item 9-B(2) may be limited to charges that are currently pending. </em> </p>
<h3>Regulatory Action Disclosure</h3>
<p>If the answer is &quot;Yes&quot; to any question in Parts C-G below, complete a <b><u>Regulatory Action DRP.</u></b></p>
<p>Check all that apply.</p>
<h3>C. Has the <em>SEC</em>  or the <em>CFTC</em>  ever:</h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) <em>found</em>  the applicant or any <em>associated person</em>  to have made a false statement or omission? </div>
    <div class="tdStyle1 tditem10col2">
    	<xsl:choose>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isMadeFalseStatement = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isMadeFalseStatement = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:when>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isMadeFalseStatement = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isMadeFalseStatement = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-checked.jpg" alt="radio button checked"/> No
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:otherwise>
		</xsl:choose>          
    </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) <em>found</em>  the applicant or any <em>associated person</em>  to have been <em>involved</em>  in a violation of any <em>SEC</em>  or <em>CFTC </em> regulation or statute? </div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isViolatedRegulation = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isViolatedRegulation = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked"/> Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:when>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isViolatedRegulation = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isViolatedRegulation = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-checked.jpg" alt="radio button checked"/> No
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:otherwise>
		</xsl:choose>         
     </div>
  </div>
  <div style="clear:both"></div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) <em>found</em>  the applicant or any <em>associated person</em>  to have been a cause of the denial, suspension, revocation, or restriction of the authorization of a <em>municipal advisor-related</em>  or an <em>investment-related</em>  business to operate? </div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isCauseOfDenial  = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isCauseOfDenial  = 'y'">
					<img src="Images/radio-checked.jpg" alt="radio button checked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/> No
			</xsl:when>
			<xsl:when
				test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isCauseOfDenial = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isCauseOfDenial = 'n'">
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-checked.jpg" alt="radio button checked" /> No
			</xsl:when>
			<xsl:otherwise>
					<img src="Images/radio-unchecked.jpg" alt="radio button unchecked"/>Yes<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
			</xsl:otherwise>
		</xsl:choose>        
    </div>
  </div>
  <div style="clear:both"></div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(4) entered an <em>order</em>  against the applicant or any <em>associated person</em>  in connection with <em>municipal advisor-related</em>  or <em>investment-related</em>  activity? </div>
    <div class="tdStyle1 tditem10col2">		
    	<xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainst = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainst= 'y'">
						<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainst = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainst = 'n'">
						<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
						  
				</xsl:when>
				<xsl:otherwise>
						<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
				</xsl:otherwise>
		</xsl:choose>  
		 </div>
  </div>
  <div style="clear:both"></div>
</div>
 
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(5) imposed a civil money penalty on the applicant or any <em>associated person</em>, or <em>ordered</em>  the applicant or any <em>associated person</em>  to cease and desist from any activity? </div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isImposedPenalty = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isImposedPenalty = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isImposedPenalty = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isImposedPenalty = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>          
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3>D. Has any other federal regulatory agency, any state regulatory agency, or any <em>foreign financial regulatory authority </em>  ever: </h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) <em>found</em>  the applicant or any <em>associated person</em>  to have made a false statement or omission, or been dishonest, unfair, or unethical?</div>
    <div class="tdStyle1 tditem10col2">
    
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isUnEthical= 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isUnEthical= 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isUnEthical = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isUnEthical = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>            
     </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) <em>found</em>  the applicant or any <em>associated person</em>  to have been <em>involved</em>  in a violation of <em>municipal advisor-related</em>  or <em>investment-related</em>  regulations or statutes?</div>
    <div class="tdStyle1 tditem10col2">
    
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRegulation= 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRegulation = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRegulation = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRegulation = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>             
     </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3) <em>found</em>  the applicant or any <em>associated person</em>  to have been the cause of a denial, suspension, revocation, or restriction of the authorization of a <em>municipal advisor-related</em>  or an <em>investment-related</em>  business to operate?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfDenial = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfDenial  = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfDenial = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfDenial = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>       
    </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(4) entered an <em>order</em>  against the applicant or any <em>associated person</em>  in connection with a <em>municipal advisor-related</em>  or <em>investment-related</em>  activity?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainstActivity = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainstActivity = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainstActivity = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isOrderAgainstActivity = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>        
    
     </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(5) denied, suspended, or revoked the registration or license of the applicant or that of any <em>associated person</em>, or otherwise prevented the applicant or any <em>associated person</em>, by <em>order</em>, from associating with a <em>municipal advisor-related</em>  or <em>investment-related </em>  business or restricted the activities of the applicant or any <em>associated person</em>? </div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDeniedLicense = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDeniedLicense = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDeniedLicense = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDeniedLicense = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>         
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3>E. Has any <em>self-regulatory organization</em>  or commodities exchange ever: </h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(1) <em>found</em>  the applicant or any <em>associated person</em>  to have made a false statement or omission?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundMadeFalseStatement = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundMadeFalseStatement = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundMadeFalseStatement = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundMadeFalseStatement = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>             
     </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(2) <em>found</em>  the applicant or any <em>associated person</em>  to have been <em>involved</em>  in a violation of its rules (other than a violation designated as a &quot;<em>minor rule violation</em>&quot; under a plan approved by the <em>SEC</em>)?</div>
    <div class="tdStyle1 tditem10col2">
		<xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRules = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRules = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRules = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInViolationOfRules = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>           
    </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(3)<em> found</em>  the applicant or any <em>associated person</em>  to have been the cause of a denial, suspension, revocation or restriction of the authorization of a <em>municipal advisor-related</em>  or an <em>investment-related</em>  business<b> </b> to operate? </div>
    <div class="tdStyle1 tditem10col2">		
    <xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfSuspension = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfSuspension = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfSuspension = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isFoundInCauseOfSuspension = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose> 
      </div>
  </div>
  <div style="clear:both"></div>
</div>
  <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">(4) disciplined the applicant or any <em>associated person</em>  by expelling or suspending the applicant or the <em>associated person</em>  from membership, barring or suspending the applicant or the <em>associated person</em>  from association with other members, or by otherwise restricting the activities of the applicant or the <em>associated person</em>?</div>
    <div class="tdStyle1 tditem10col2">
    <xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDiscipliend = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDiscipliend = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDiscipliend = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isDiscipliend = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>     
     </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3> F. Revocation or Suspension: </h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">Has the applicant or any <em>associated person</em>  ever had an authorization to act as an attorney, accountant, or federal contractor revoked or suspended?</div>
    <div class="tdStyle1 tditem10col2">
    <xsl:choose>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isAuthorizedToActAttorney = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isAuthorizedToActAttorney = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
						</xsl:when>
						<xsl:when
							test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isAuthorizedToActAttorney = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isAuthorizedToActAttorney = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
						</xsl:when>
						<xsl:otherwise>
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
						</xsl:otherwise>
						
			</xsl:choose>         
     </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3>G. Regulatory <em>Proceedings: </em></h3>
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1">Is the applicant or any <em>associated person</em>  currently the subject of any regulatory <em>proceeding</em>  that could result in a &quot;Yes&quot; answer to any part of Item 9-C, 9-D, or 9-E.? </div>
   <div class="tdStyle1 tditem10col2">
    
    <xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isRegulatoryComplaint  = 'Y' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isRegulatoryComplaint  = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isRegulatoryComplaint = 'N' or m1:disclosureAnswers/m1:regulatoryDisclosure/ns2:isRegulatoryComplaint  = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
					</xsl:when>
					<xsl:otherwise>
							<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
						
			</xsl:choose>           
    </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3>Civil Judicial Disclosure</h3>
<p><em>If the answer is &quot;Yes&quot; to a question below, complete a <b><u>Civil Judicial Action DRP.</u></b></em> </p>
<p>Check all that apply.</p>
<h3>H. (1) Has any domestic or foreign court ever: </h3>
  <div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"><p>(a) <em>enjoined</em>  the applicant or any <em>associated person</em>  in connection with any <em>municipal advisor-related</em>  or <em>investment-related</em> activity?</p></div>
      <div class="tdStyle1 tditem10col2">
		    <xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isEnjoined = 'Y' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isEnjoined = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isEnjoined = 'N' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isEnjoined = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
					</xsl:when>
					<xsl:otherwise>
							<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
						
			</xsl:choose>        
       </div>
  </div>
  <div style="clear:both"></div>
</div>
    <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"><p>(b) <em>found</em> that the applicant or any <em>associated person</em>  was <em>involved</em>  in a violation of any <em>municipal advisor-related</em> or <b> </b><em>investment-related</em>  statute(s) or regulation(s)?</p></div>
     <div class="tdStyle1 tditem10col2">
		    <xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isFoundInViolationOfRegulation = 'Y' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isFoundInViolationOfRegulation = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isFoundInViolationOfRegulation = 'N' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isFoundInViolationOfRegulation = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
					</xsl:when>
					<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
						
			</xsl:choose>          
       </div>
  </div>
  <div style="clear:both"></div>
</div>
    <div class="tablebottom" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"><p>(c) dismissed, pursuant to a settlement agreement, a <em>municipal advisor-related</em>  or <em>investment-related </em>  civil action brought against the applicant or any <em>associated person</em>  by a state or other US jurisdiction or a <b> </b><em> foreign financial regulatory authority</em>? </p></div>
      <div class="tdStyle1 tditem10col2">
		    <xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isDismissed = 'Y' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isDismissed = 'y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isDismissed = 'N' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isDismissed = 'n'">
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
					</xsl:when>
					<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
						
			</xsl:choose>               
      </div>
  </div>
  <div style="clear:both"></div>
</div>
<h3><b>&#160;&#160;(2) Current <em>Proceedings:</em></b></h3>
<!-- p><b>(2) Current <em>Proceedings:</em></b></p-->
<div class="tableStyle" style="margin-left:0; margin-right:0;">
  <div>
    <div class="tdStyle1 tdLabelStyleBgcolor tditem10col1"><p>Is the applicant or any <em>associated person</em>  the subject of any currently pending civil <em>proceeding </em>  that could result in a &quot;Yes&quot; answer to any part of Item 9-H(1)? </p></div>
    <div class="tdStyle1 tditem10col2">
		    <xsl:choose>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isNamedInCivilProceeding = 'Y' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isNamedInCivilProceeding = 'y'">
								<img 	src="Images/radio-checked.jpg" alt="radio button checked" /> Yes <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
								  
				</xsl:when>
				<xsl:when
					test="m1:disclosureAnswers/m1:civilDisclosure/ns2:isNamedInCivilProceeding = 'N' or m1:disclosureAnswers/m1:civilDisclosure/ns2:isNamedInCivilProceeding = 'n'">
								<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 	src="Images/radio-checked.jpg" alt="radio button checked" /> No
								  
					</xsl:when>
					<xsl:otherwise>
							<img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" />Yes  <img 		src="Images/radio-unchecked.jpg" alt="radio button unchecked" /> No
					</xsl:otherwise>
						
			</xsl:choose>           
    </div>
  </div>
  <div style="clear:both"></div>
</div>
</xsl:template>

</xsl:stylesheet>